/*
 * Decompiled with CFR 0.152.
 */
package org.magmafoundation.magma.patcher.impl;

import java.util.Locale;
import java.util.function.Consumer;
import org.magmafoundation.magma.patcher.Patcher;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

@Patcher.PatcherInfo(name="WorldEdit", description="Patches WorldEdit")
public class WorldEditPatcher
extends Patcher {
    private static final String PAPERWEIGHT_ADAPTER = "com.sk89q.worldedit.bukkit.adapter.impl.v1_18_R2.PaperweightAdapter$SpigotWatchdog";

    @Override
    public byte[] transform(String className, byte[] basicClass) {
        Consumer<ClassNode> patcher = switch (className) {
            case "com.sk89q.worldedit.bukkit.BukkitAdapter" -> WorldEditPatcher::handleBukkitAdapter;
            case "com.sk89q.worldedit.bukkit.adapter.Refraction" -> WorldEditPatcher::handlePickName;
            case PAPERWEIGHT_ADAPTER -> WorldEditPatcher::handleWatchdog;
            default -> null;
        };
        return patcher == null ? basicClass : WorldEditPatcher.patch(basicClass, patcher);
    }

    private static byte[] patch(byte[] basicClass, Consumer<ClassNode> handler) {
        ClassNode node = new ClassNode();
        new ClassReader(basicClass).accept((ClassVisitor)node, 0);
        handler.accept(node);
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private static void handleBukkitAdapter(ClassNode node) {
        MethodNode standardize = new MethodNode(4106, "patcher$standardize", Type.getMethodDescriptor((Type)Type.getType(String.class), (Type[])new Type[]{Type.getType(String.class)}), null, null);
        try {
            GeneratorAdapter adapter = new GeneratorAdapter((MethodVisitor)standardize, standardize.access, standardize.name, standardize.desc);
            adapter.loadArg(0);
            adapter.push(58);
            adapter.push(95);
            adapter.invokeVirtual(Type.getType(String.class), Method.getMethod((java.lang.reflect.Method)String.class.getMethod("replace", Character.TYPE, Character.TYPE)));
            adapter.push("\\s+");
            adapter.push("_");
            adapter.invokeVirtual(Type.getType(String.class), Method.getMethod((java.lang.reflect.Method)String.class.getMethod("replaceAll", String.class, String.class)));
            adapter.push("\\W");
            adapter.push("");
            adapter.invokeVirtual(Type.getType(String.class), Method.getMethod((java.lang.reflect.Method)String.class.getMethod("replaceAll", String.class, String.class)));
            adapter.getStatic(Type.getType(Locale.class), "ENGLISH", Type.getType(Locale.class));
            adapter.invokeVirtual(Type.getType(String.class), Method.getMethod((java.lang.reflect.Method)String.class.getMethod("toUpperCase", Locale.class)));
            adapter.returnValue();
            adapter.endMethod();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        node.methods.add(standardize);
        for (MethodNode method : node.methods) {
            if (!method.name.equals("adapt")) continue;
            WorldEditPatcher.handleAdapt(node, standardize, method);
        }
    }

    private static void handleAdapt(ClassNode node, MethodNode standardize, MethodNode method) {
        switch (method.desc) {
            case "(Lcom/sk89q/worldedit/world/item/ItemType;)Lorg/bukkit/Material;": 
            case "(Lcom/sk89q/worldedit/world/block/BlockType;)Lorg/bukkit/Material;": 
            case "(Lcom/sk89q/worldedit/world/biome/BiomeType;)Lorg/bukkit/block/Biome;": 
            case "(Lcom/sk89q/worldedit/world/entity/EntityType;)Lorg/bukkit/entity/EntityType;": {
                for (AbstractInsnNode instruction : method.instructions) {
                    if (instruction.getOpcode() != 191) continue;
                    InsnList list = new InsnList();
                    list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    list.add((AbstractInsnNode)new MethodInsnNode(182, Type.getMethodType((String)method.desc).getArgumentTypes()[0].getInternalName(), "getId", "()Ljava/lang/String;", false));
                    list.add((AbstractInsnNode)new MethodInsnNode(184, node.name, standardize.name, standardize.desc, false));
                    switch (Type.getMethodType((String)method.desc).getReturnType().getInternalName()) {
                        case "org/bukkit/Material": {
                            list.add((AbstractInsnNode)new MethodInsnNode(184, "org/bukkit/Material", "getMaterial", "(Ljava/lang/String;)Lorg/bukkit/Material;", false));
                            break;
                        }
                        case "org/bukkit/block/Biome": {
                            list.add((AbstractInsnNode)new MethodInsnNode(184, "org/bukkit/block/Biome", "valueOf", "(Ljava/lang/String;)Lorg/bukkit/block/Biome;", false));
                            break;
                        }
                        case "org/bukkit/entity/EntityType": {
                            list.add((AbstractInsnNode)new MethodInsnNode(184, "org/bukkit/entity/EntityType", "fromName", "(Ljava/lang/String;)Lorg/bukkit/entity/EntityType;", false));
                        }
                    }
                    list.add((AbstractInsnNode)new InsnNode(176));
                    method.instructions.insert(instruction, list);
                    method.instructions.set(instruction, (AbstractInsnNode)new InsnNode(87));
                    return;
                }
                break;
            }
        }
    }

    private static void handlePickName(ClassNode node) {
        for (MethodNode method : node.methods) {
            if (!method.name.equals("pickName")) continue;
            method.instructions.clear();
            method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            method.instructions.add((AbstractInsnNode)new InsnNode(176));
            return;
        }
    }

    private static void handleWatchdog(ClassNode node) {
        if (node.interfaces.size() == 1 && ((String)node.interfaces.get(0)).equals("com/sk89q/worldedit/extension/platform/Watchdog") && node.name.contains("SpigotWatchdog")) {
            for (MethodNode method : node.methods) {
                if (!method.name.equals("<init>")) continue;
                method.instructions.clear();
                method.instructions.add((AbstractInsnNode)new TypeInsnNode(187, "java/lang/ClassNotFoundException"));
                method.instructions.add((AbstractInsnNode)new InsnNode(89));
                method.instructions.add((AbstractInsnNode)new MethodInsnNode(183, "java/lang/ClassNotFoundException", "<init>", "()V", false));
                method.instructions.add((AbstractInsnNode)new InsnNode(191));
                method.tryCatchBlocks.clear();
                method.localVariables.clear();
                return;
            }
        }
    }
}

